#ifndef _CSG2DLT645_H_
#define _CSG2DLT645_H_

//////////////////////////////////////////////////////////////////////////////////////
////////////////////function define//////////////////////////////////////////////////
#define DLT645_SUPPORT
#define SINGLE_PHASE

#define SERIAL_CALIBRATION_SUPPORT
#define SERIAL_CALIBRATION_PASSWORD_1               0x1234
#define SERIAL_CALIBRATION_PASSWORD_2               0x5678
#define SERIAL_CALIBRATION_PASSWORD_3               0x9ABC
#define SERIAL_CALIBRATION_PASSWORD_4               0xDEF0

#define PASSWORD_OK                     0x0040

#define NEUTRAL_MONITOR_SUPPORT                     1
#define PHASE_CORRECTION_SUPPORT
//#define RTC_SUPPORT
//#define CORRECTED_RTC_SUPPORT
//#define TEMPERATURE_SUPPORT

#define VRMS_SUPPORT                                1
#define IRMS_SUPPORT                                1
#define REACTIVE_POWER_SUPPORT                      1
#define REACTIVE_POWER_BY_QUADRATURE_SUPPORT        1
#define APPARENT_POWER_SUPPORT                      1
#define POWER_FACTOR_SUPPORT
#define MAINS_FREQUENCY_SUPPORT                     1
//////////////////////////////////////////////////////////////////////////////////////
////////////////////customer function function //////////////////////////////////////////////////
#define send_calibration_data()
#define send_config_data()
//#define send_AFE_reading(i)

#define custom_set_consumption(x,y)                 /**/
#define custom_magnetic_sensor_test()               /**/
#define custom_adc_interrupt()                      /**/
#define custom_rf_sniffer()                         /**/
#define custom_rf_exchange()                        /**/
#define custom_rtc()                                /* not used */
#define custom_rtc_set()                            /* not used */
#define custom_rtc_retrieve(x)                      /* not used */
#define custom_energy_pulse()                       /* not used */
#define custom_keypad_handler()                     /* not used */
#define custom_mainloop_handler()                   /* not used */
#define custom_power_fail_handler()                 /* not used */
#define custom_power_restore_handler()              /* not used */



//////////////////////////////////////////////////////////////////////////////////////
////////////////////convert steve's info mem structure to csg/////////////////////////
typedef int32_t dc_estimate_t;

struct current_sensor_nv_parms_s
{
#if defined(IRMS_SUPPORT)
    /*! The scaling factor between the raw RMS current value, and milliamps, when in
        normal operation. */
    int16_t I_rms_scale_factor[GAIN_STAGES];
    #if defined(LIMP_MODE_SUPPORT)
    /*! The scaling factor between the raw RMS current value, and milliamps when in
        limp mode. */
    int16_t I_rms_limp_scale_factor[GAIN_STAGES];
    #endif
    /*! An offset to remove an approximation of the front end noise from the measured RMS
        current. */
    int32_t ac_offset;
#endif
    /*! The scaling factor between the raw active power value, and 0.1W increments, when in
        normal operation. */
    int16_t P_scale_factor[GAIN_STAGES];
    /*! An initial value for the DC estimate, to ensure rapid settling after reset. */
    dc_estimate_t initial_dc_estimate;
#if defined(PHASE_CORRECTION_SUPPORT)
    int16_t phase_correction[GAIN_STAGES];
#endif
};
/*! This structure contains the non-volatile parameters associated with a phase. */
struct phase_nv_parms_s
{
    /*! \brief The non-volatile information (e.g. calibration parameters) for a current channel. */
    struct current_sensor_nv_parms_s current;
#if defined(VRMS_SUPPORT)
    /*! \brief The calibration scaling factor for the measured RMS voltage. */
    int16_t V_rms_scale_factor;
    #if defined(LIMP_MODE_SUPPORT)
    /*! \brief The calibration scaling factor for the measured RMS voltage in limp mode. */
    int16_t V_rms_limp_scale_factor;
    #endif
#endif
    /*! \brief A value used to prime the voltage signal DC estimate, to ensure quick settling, when the
               meter is powered up. It is set during the calibration process, based on the DC estimate
               measured at that time. */
    dc_estimate_t initial_v_dc_estimate;
#if defined(LIMP_MODE_SUPPORT)
    /*! \brief A value used to prime the voltage signal DC estimate in limp mode, to ensure quick settling,
               when the meter is powered up. It is set during the calibration process, based on the DC estimate
               measured at that time. */
    dc_estimate_t initial_v_limp_dc_estimate;
#endif
};

/*! This structure is an image of the non-volatile calibration parameters
    stored in the info memory. */
struct nv_parms_s
{
    /*! \brief 0xFF (i.e. the erased state of the flash memory) for an uncalibrated meter.
               0x00 for a calibrated one. */
    int16_t meter_uncalibrated;
#if defined(SELF_TEST_SUPPORT)
    /*! \brief A place to permanently record failures detected in the meter. */
    int16_t meter_failures;
    /*! \brief A place to permanently record recoverable failures detected in the meter. */
    int16_t meter_warnings;
#endif
#if defined(SINGLE_PHASE)
    struct phase_nv_parms_s chan1;
#else
    /*! \brief The non-volatile per channel information (e.g. calibration parameters). */
    struct phase_nv_parms_s chan[NUM_PHASES];
#endif
#if defined(NEUTRAL_MONITOR_SUPPORT)
    /*! \brief The non-volatile neutral lead information (e.g. calibration parameters). */
    struct current_sensor_nv_parms_s neutral;
#endif
#if defined(TEMPERATURE_SUPPORT)
    /*! \brief The room temperature at the time of calibration, in degrees Celcius */
    uint16_t temperature_at_calibration;
    /*! \brief The DC offset of readings from the temperature sensor, relative to zero Celcius. */
    uint16_t temperature_offset;
    /*! \brief The scaling factor between readings from the temperature sensor, and degrees Celcius. */
    uint16_t temperature_scaling;
#endif
#if defined(CORRECTED_RTC_SUPPORT)
    /*! \brief The basic parts per million error of the 32kHz crystal. */
    int32_t crystal_base_correction;
#endif
    /*! \brief A snapshot of the meter's RTC, taken at calibration time. If the calibration process
               has correctly set the RTC, this should be a record of when the meter was calibrated. */
    uint8_t rtc_at_calibration[7];
    /*! \brief Pad to word alignment */
    uint8_t xxx;
    /* Keep these administrative strings an even number of bytes each */
    /*! \brief The serial number of the meter */
    uint8_t serial_number[16 + 2];
    /*! \brief The property number of the meter (see IEC1107). */
    uint8_t property_number[16 + 2];
    /*! \brief The factory number of the meter (see IEC1107). */
    uint8_t factory_number[10 + 2];
};

/*! This union overlays a segment of the info, ensuring correct
   alignment. */
struct info_mem_s
{
    union
    {
        struct nv_parms_s s;
        int8_t x[128];
    } seg_a;
#if 0
    union
    {
        int8_t x[128];
    } seg_b;
#endif
};


#endif